<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use App\Models\Settings;
use Exception;

class SendWpService
{
    protected $apiUrl;
    protected $username;
    protected $api_token;
    // protected $httpClient;

    public function __construct()
    {
       $this->apiUrl = 'https://int.chatway.in/api/send-msg';
       $this->username = 'WTMIT';

       $settings = Settings::where('type', 'whatsapp')->get();

       $tokenSetting = $settings->where('name', 'infoinfra_token')->first();

       $this->api_token = $tokenSetting ? $tokenSetting->value : '';

       $this->whatsappApiStatus = $settings->where('name', 'status')->first() &&
                                 $settings->where('name', 'status')->first()->value == 0 ? 0 : 1;
    }

    public function sendMessageWithTemplate(string $mobileNumber, int $templateId, array $placeholders = []) : array
    {
        if ($this->whatsappApiStatus === 0) {
            return [];
        }
        try {
            if (!preg_match('/^91/', $mobileNumber)) {
                $mobileNumber = '91' . $mobileNumber;
            }
            if (!preg_match('/^\d{12}$/', $mobileNumber)) {
                return ["status" => "error", "message" => "Invalid number format"];
            }

            $template = WhatsappTemplate::where('temp_id', $templateId)->select('body')->first();

            if (!$template) {
                return ["status" => "error", "message" => "Template not found"];
            }

            $message = $this->replacePlaceholders($template->body, $placeholders);

            $message = strip_tags($message);
            $params = [
                'username' => $this->username,
                'number'   => $mobileNumber,
                'message'  => $message,
                'token'    => $this->api_token
            ];

            $response = Http::get($this->apiUrl, $params);

            if ($response->getStatusCode() >= 200 && $response->getStatusCode() < 300) {
                return ["status" => "success", "message" => "Message sent", "response" => $response->getBody()->getContents()];
            } else {
                Log::error('Failed to send WhatsApp message. Response: ' . $response->getBody()->getContents());
                return ["status" => "error", "message" => "Failed to send message", "response" => $response->getBody()->getContents()];
            }
        } catch (Exception $e) {
            Log::error('Exception in sending WhatsApp message: ' . $e->getMessage());
            return ["status" => "error", "message" => $e->getMessage()];
        }
    }

    private function replacePlaceholders(string $templateBody, array $placeholders): string
    {
        foreach ($placeholders as $key => $value) {
            $templateBody = str_replace('{' . $key . '}', $value, $templateBody);
        }

        $templateBody = html_entity_decode($templateBody);
        $templateBody = strip_tags($templateBody);

        return $templateBody;
    }

}

